/*
 * Decompiled with CFR 0.152.
 */
package edu.greenriver.sdiv.myspringproject.securityconfig;

import edu.greenriver.sdiv.myspringproject.service.UserService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@EnableWebSecurity
public class SecurityConfig
extends WebSecurityConfigurerAdapter {
    private UserService userService;

    public SecurityConfig(UserService userService) {
        this.userService = userService;
    }

    @Bean
    public BCryptPasswordEncoder encoder() {
        return new BCryptPasswordEncoder();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        BCryptPasswordEncoder encoder = this.encoder();
        auth.userDetailsService((UserDetailsService)this.userService).passwordEncoder((PasswordEncoder)encoder);
    }

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/resources/**"})).and().ignoring().antMatchers(new String[]{"/h2-console/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/admin", "/resume/**"})).hasAnyAuthority(new String[]{"admin"}).antMatchers(new String[]{"/resume/**"})).hasAnyAuthority(new String[]{"user"}).antMatchers(new String[]{"/index"})).permitAll().and()).formLogin().defaultSuccessUrl("/resume")).loginPage("/login").failureForwardUrl("/login").failureUrl("/login?error=true")).and()).logout().permitAll().logoutUrl("/logout").logoutSuccessUrl("/login?logout=true");
    }

    public String toString() {
        return "SecurityConfig{userService=" + this.userService + "}";
    }
}

