/*
 * Decompiled with CFR 0.152.
 */
package edu.greenriver.sdiv.myspringproject.controllers;

import edu.greenriver.sdiv.myspringproject.models.ResumeData;
import edu.greenriver.sdiv.myspringproject.service.ResumeService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"myresume"})
@CrossOrigin(origins={"*"})
public class ResumeApiController {
    private ResumeService service;

    public ResumeApiController(ResumeService service) {
        this.service = service;
    }

    @GetMapping
    public ResponseEntity<List<ResumeData>> allData() {
        return new ResponseEntity(this.service.allData(), HttpStatus.OK);
    }

    @GetMapping(value={"{id}"})
    public ResponseEntity<ResumeData> dataById(@PathVariable int id) {
        if (!this.service.dataExist(id)) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)this.service.byId(id), HttpStatus.OK);
    }

    @PostMapping
    public ResponseEntity<ResumeData> addData(@RequestBody ResumeData data) {
        return new ResponseEntity((Object)this.service.saveData(data), HttpStatus.CREATED);
    }

    @PutMapping
    public ResponseEntity<ResumeData> editData(@RequestBody ResumeData data) {
        if (!this.service.dataExist(data.getId())) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)this.service.editData(data), HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"{id}"})
    public ResponseEntity<ResumeData> deleteData(@PathVariable int id) {
        this.service.deleteRecord(id);
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    public String toString() {
        return "ResumeApiController{service=" + this.service + "}";
    }
}

