/*
 * Decompiled with CFR 0.152.
 */
package edu.greenriver.sdiv.myspringproject.controllers;

import edu.greenriver.sdiv.myspringproject.models.ResumeData;
import edu.greenriver.sdiv.myspringproject.models.User;
import edu.greenriver.sdiv.myspringproject.service.ResumeService;
import edu.greenriver.sdiv.myspringproject.service.UserService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class IndexController {
    private final ResumeService service;
    private final UserService userService;
    private BCryptPasswordEncoder encoder;

    public IndexController(ResumeService service, UserService userService) {
        this.service = service;
        this.userService = userService;
    }

    @RequestMapping(path={"", "/", "index", "index.html", "resume"})
    public String home() {
        return "home/index";
    }

    @RequestMapping(value={"resume/summary"})
    public String summary(Model model) {
        model.addAttribute("data", this.service.allData());
        return "home/summary";
    }

    @RequestMapping(value={"resume/summary/individual"})
    public String individualElm() {
        return "home/individual-element";
    }

    @RequestMapping(value={"resume/form"})
    public String formLoad() {
        return "home/form";
    }

    @RequestMapping(value={"resume/summary/individual/{id}"})
    public String byId(Model model, @PathVariable int id) {
        model.addAttribute("activity", (Object)this.service.byId(id));
        return "home/individual-element";
    }

    @GetMapping(value={"resume/form"})
    public String loadForm(Model model) {
        model.addAttribute("newData", (Object)new ResumeData());
        return "home/form";
    }

    @PostMapping(value={"resume/form"})
    public String submitForm(@ModelAttribute ResumeData newData) {
        this.service.saveData(newData);
        return "redirect:/resume/summary";
    }

    @GetMapping(value={"resume/edit/{id}"})
    public String editForm(Model model, @PathVariable int id) {
        ResumeData newData = this.service.byId(id);
        model.addAttribute("newData", (Object)newData);
        return "home/form";
    }

    @PostMapping(value={"resume/edit"})
    public String saveEditedForm(Model model, @ModelAttribute ResumeData newData) {
        model.addAttribute("newData", (Object)newData);
        this.service.saveData(newData);
        return "redirect:/resume/summary";
    }

    @RequestMapping(path={"/resume/{id}"})
    public String deletebyId(@PathVariable int id) {
        this.service.deleteRecord(id);
        return "redirect:/resume/summary";
    }

    @RequestMapping(path={"consumer", "consumer.html"})
    public String showConsumerPage() {
        return "/home/consumer";
    }

    @RequestMapping(path={"admin", "admin.html"})
    public String adminPage() {
        return "/home/admin";
    }

    @RequestMapping(value={"resume/userform"})
    public String userForm() {
        return "home/userform";
    }

    @PostMapping(value={"resume/userform"})
    public String register(@ModelAttribute User newUser) {
        this.userService.saveUser(newUser);
        return "redirect:/resume";
    }

    @RequestMapping(value={"/login"})
    public String login() {
        return "home/login";
    }

    @RequestMapping(path={"resume/logout", "logout"})
    public String gologout() {
        return "home/logout";
    }

    @PostMapping(value={"/logout"})
    public String logout() {
        return "redirect:/login";
    }

    public String toString() {
        return "IndexController{service=" + this.service + "}";
    }
}

